# 陰陽五行カラーCSS v1.3 詳細仕様書

**五行×陰陽＝10色の統一パレット**

陰陽五行カラーCSS v1.3 は、命理学の最も古い骨格である五行・陰陽・十干・十二支を、色相と明度という"視覚の言語"に翻訳した世界初のUI仕様です。

古典の理論を一切改変せず、**UIレイヤーだけを近代化する「OS補完パッチ」**として設計されています。

## 📐 基本設計思想

- **五行** → 色相（Hue）
- **陰陽** → 明度（Lightness）
- **十干** → 五行×陰陽＝10色
- **十二支** → 属する五行×陰陽をそのまま継承

文章を読む前に、命理の構造そのものが色だけで自然に立ち上がる──その体験を可能にしたのが、このCSSパレットです。

たった10色。しかし、十干・十二支・大運・流年・命式のすべてがこの10色で統一的に理解できます。

---

## 【SECTION 1｜このCSSは何か】

陰陽五行カラーCSS v1.3 は、命理学の基礎構造をそのまま保持したまま、「表示レイヤーだけ」を現代のUI規格へ翻訳したCSSパレットです。

四柱推命の世界には、五行・陰陽・十干・十二支という確立した理論体系があります。しかし、これらを**視覚的に統一ルールで扱う規格**は存在しませんでした。

### 本CSSが行うのは理論の改変ではありません

行っているのは**"UI(見た目)の標準化"**です。

- **五行** → 色相（Hue）の違いとして固定
- **陰陽** → 明度（Lightness）の濃淡として統合  
- **十干** → 五行×陰陽の組み合わせで10色化
- **十二支** → 所属する五行×陰陽の色をそのまま継承

これにより、十干も十二支も、命式も、流年も、すべてが同じ1つの表示規格で可視化可能になります。

理論とUIを無理に噛み合わせるのではなく、理論そのものを"色の構造"へ忠実にマッピングした結果生まれたCSS──それが本パレットの本質です。

文章を読む前に、命理の構造そのものが色だけで自然に立ち上がるよう設計されています。

---

## 【SECTION 2｜なぜ作ったのか】

四柱推命や命理を学んでいると、「五行の流れを追う」のに思った以上の負荷がかかります。

命式でも、鑑定文でも、教材でも、五行・陰陽・十干・十二支を毎回すべて"頭の中で変換"する必要があるからです。

### 🎨 だから「色で見た目を統一する方法」が必要だった

本CSSは、専門用語で言えば「CSS」「UIデザイン」といった言葉が登場しますが、**占い師目線では"色で表示を統一するための仕組み"と言った方が正確です。**

難しい技術を使った新しい占いではなく、"見た目の工夫で、五行や陰陽を読みやすくする方法"これがこのCSSの正体です。

### 🤝 現場のリアルな負荷を減らしたかった

占い師や学習者の現場では、五行の流れや干支の性質を文字だけで追うために、どうしても次のような負荷がかかります。

- 五行のつながりが一瞬わかりにくい
- 年運の変化を追うのに頭の中で色付けしている
- 鑑定文を読み進めながら五行を何度も再確認する
- 文章が重く感じる理由のひとつが「視覚情報の欠落」

つまり、知識のせいで難しいのではなく、**表示のせいで難しくなっている**。

### 👁️‍🗨️ 視覚化するだけで、"命理の難しさ"が半分消える

五行を"色の違い"として統一してしまえば、それだけで理解速度は大幅に上がります。

色を見れば、それが木なのか、火なのか、陰なのか、陽なのか瞬間で判断できる。脳内変換が不要になる。

すると、鑑定文も命式も、本来の内容に集中できるようになる。

---

## 【SECTION 3｜配色理念（v1.3 統一思想）】

陰陽五行カラーCSS v1.3 の色づけは、「五行本来のイメージ」をそのまま視覚に置き換えたものです。

難しい理論ではなく、誰でも感じ取れる自然のイメージを土台にしています。

### 🌳 木（Green）── 自然の色として"緑"

木は、芽吹き・成長・柔軟・伸展。自然界で木を見たとき、私たちは迷わず緑を連想します。

- **甲（陽木）**は生命力の強い"濃い緑"
- **乙（陰木）**はしなやかな草木の"明るい緑"

木の陰陽は、強さではなく質感の違いとして表現しています。

### 🔥 火（Red）── 温度と勢いの"赤"

火は、熱・発火・情熱・行動。赤は温度を最も強く感じる色であり、火の象意と自然に重なります。

- **丙（陽火）**は太陽のような"強い赤"
- **丁（陰火）**は灯火のような"やわらかな赤"

"燃え上がる火"と"静かに灯る火"を明度で分けています。

### 🟫 土（Brown）── 大地の"茶色"

土は、受容・安定・育成・蓄積。地面や大地の色として、茶系が最も自然です。

- **戊（陽土）**は大地そのものの"濃い茶"
- **己（陰土）**は表土のような"明るいブラウン"

土の「陽と陰」は、深さと表面のイメージで分けています。

### 🟨 金（Gold）── 価値と輝きの"金色"

金は、鋭さ・決断・硬質・価値。金属が光を反射する"金色系"が最も象意に合います。

- **庚（陽金）**は金属光沢のある"黄金色"
- **辛（陰金）**は精錬された"ライトゴールド"

硬さの違いではなく、輝度の違いとして陰陽を区別します。

### 💧 水（Blue）── 深さと流動の"青"

水は、知恵・冷静・流動・吸収。青は深海から水面までの色を自然に表します。

- **壬（陽水）**は深海のような"濃い青"
- **癸（陰水）**は水面のような"淡い青"

水の陰陽は、深さと透明感で表現しています。

### 🎨 陰陽は「明度」で表現する理由

陰陽は、良い悪いではなく光の当たり方の違いです。

- **陽** → 光が強い（濃い・深い）
- **陰** → 光が柔らかい（明るい・淡い）

強弱ではなく、性質の違いを"明度の差"として視覚化しています。

---

## 【SECTION 4｜実例適用：Before→After】

陰陽五行カラーCSS v1.3 の真価が現れるのは、**「実際の文章に色が入ったとき」**です。

### 🔵 Before：色がない世界（従来の命理文の問題点）

```
癸丑
乙酉  
庚辰
```

このような干支を並べられて、直感的に五行や陰陽の関係性を一瞬で掴めるでしょうか？

多くの場合、次のような"頭の中の変換作業"が必要になります：

- 「癸は水の陰で……」
- 「乙は木の陰で……」  
- 「酉は金の陰で……」

文章を読む前に、五行の判別に脳のリソースを消費してしまう状態です。

### 🔴 After：色パッチ後（v1.3 適用後の世界）

同じ内容に五行＝色相／陰陽＝明度のv1.3パレットを適用すると、文章がまったく違う表情を見せます。

#### ✔ ① 五行レーンが"視覚で"現れる

- 木 → 緑
- 火 → 赤  
- 土 → 茶
- 金 → 金
- 水 → 青

文章の中に、五行の縦レーンが浮き上がります。読む前に流れが見える状態になります。

#### ✔ ② 木→火の遷移が"一瞬で理解できる"

```html
2023：癸卯（陰水 → 陰木）
2024：甲辰（陽木）
2025：乙巳（陰木 → 陰火）  
2026：丙午（陽火 × 陽火）
```

本来なら文章で追う必要がある木→木→火→火の4年遷移が、色を入れた瞬間、緑→緑→赤→赤と一直線に見える。

視覚だけで理解できるので、読解負荷が半減します。

#### ✔ ③ 陰陽差が"質感の違い"として浮き上がる

- **陽** → 濃い色
- **陰** → 明るい色

例：
- 丙（陽火）＝濃い赤
- 丁（陰火）＝淡い赤

従来は文字上で区別不可能だった差が、質感として目に届くようになります。

#### ✔ ④ 読者の理解負荷が劇的に減る

- **Before**: 「これは木だっけ？火だっけ？」→ 脳内で照合
- **After**: 目で見て自動判別（脳内変換ゼロ）

読むスピードが上がり、内容への集中が増し、長文でも疲れにくくなります。

---

## 【SECTION 5｜技術実装ガイド】

### ⚠️ 技術者向けの実装内容

このセクションは実践編のため、少しWEB技術者向けの内容です。

占い師の方で技術的な実装をされない場合は、Web制作者・デザイナーの方と連携して導入していただくことを推奨します。

### 🎯 占い師の方へ

技術的な部分はWeb制作者にお任せして、以下の点を重視してください：

- **「五行・陰陽を色で統一したい」**という要望を明確に
- **このCSSファイルの存在**を制作者に伝える
- **色の効果を体験**して、どこに適用するかを決める

#### 💡 WEB制作パートナーをお探しの場合

占術の理解があるWEB制作者との連携をご希望の場合、**「ガチ占い師が在籍するリノベ屋」**という選択肢もあります：

🏗️ **AI魔晄炉・リノベ屋**  
https://rotary.ai-makouro.com/renovation/rinobeya.index.html

※占術の本質を理解したうえでのWEB制作・システム構築が可能な制作チーム

### 🔧 実装手順

#### 1. CSSファイルを読み込む

HTMLの`<head>`内に以下を追加：

```html
<link rel="stylesheet" href="yy-five-elements-color.css">
```

#### 2. 十干に色をつける

```html
<span class="stem-hei">丙</span>
<span class="stem-tei">丁</span>
<span class="stem-kyou">甲</span>
<span class="stem-otsu">乙</span>
```

#### 3. 十二支に色をつける

```html
<span class="branch-ne">子</span>
<span class="branch-uma">午</span>
<span class="branch-u">卯</span>
<span class="branch-tori">酉</span>
```

### 💡 占い師の方が確認すべきポイント

- **色の統一効果**：同じ五行は同じ色相で表示される
- **陰陽の違い**：濃淡で陰陽が自然に区別される
- **視覚的な理解速度**：文章を読む前に五行が分かる
- **疲れにくさ**：脳内変換の負荷が軽減される

これらの効果を実感していただき、サイトのどの部分に適用するかをご検討ください。

---

## 【SECTION 6｜ライセンス・配布について】

陰陽五行カラーCSS v1.3 は、どの占術サイト・ブログ・教材にも自由に組み込める**オープン仕様のカラー・パレット（UI補完パッチ）**です。

### ⚖️ ライセンス・改変について

本CSSは**無料で利用・改変・再配布可能**です。商用利用も制限はありません。

※ 引用時は「陰陽五行カラーCSS v1.3（by AI魔晄炉）」と明記していただけると助かります。

---

## 【SECTION 7｜原典・立ち位置・注意事項】

陰陽五行カラーCSS v1.3 は、四柱推命や東洋占術そのものを変えるためのツールではありません。やっていることは、あくまで**「元の理論はそのままに、見え方だけを整える」**というUIレイヤーの補完です。

### 📚 原典（思想の出どころ）

このCSSパレットの思想・規格・実装は、**AI魔晄炉（ai-makouro.com）**にて考案されました。本CSSは、その中で行われた長期運用・実験の結果、v1.0 → v1.3 までブラッシュアップされた実戦用パレットです。

### 流派・解釈についてのスタンス

本CSSは、特定の流派・解釈に依存しないよう設計されています。

- 五行配当（木・火・土・金・水）
- 陰陽（陽・陰）
- 十干・十二支の基本構造

といった、どの流派でも共通している"OS部分"だけを扱います。

---

## 【SECTION 8｜結語 — 色は、理論をやさしくする】

陰陽五行カラーCSS v1.3 は、新しい占いを作るためのものではありません。ずっと昔から存在していた五行・陰陽・十干・十二支という骨格に、ただ静かに**「色」という見え方」を足しただけ**の道具です。

### この"足しただけ"が大きな意味を持つ

- 黒い文字の中に沈んでいた五行が、色として浮かび上がる
- 頭の中で組み立てていた流れが、画面の上でそのまま見える  
- 認知の負荷が下がり、本来の内容に集中できるようになる

**五行＝色相 / 陰陽＝明度**

このルールさえ守れば、あなたのどんな文章も、表も、レポートも、同じ"五行の地図"の上に載ることができます。

> 「色は、理論を甘やかしません。  
> ただ、読む人の心と頭を少しだけ楽にしてくれます。」

陰陽五行カラーCSS v1.3 が、あなたの学びと鑑定と創作にとって、そんな**「静かな助っ人」**になれたら幸いです。

---

**Original concept & palette developed at AI魔晄炉（ai-makouro.com）**  
陰陽五行を統一色規格として整理した世界初のUIパッチ