# 陰陽五行カラーCSS v1.3

**五行×陰陽＝10色の統一パレット**

陰陽五行カラーCSS v1.3 は、命理学の基礎構造である五行・陰陽・十干・十二支を、色相と明度で統一表示する世界初のUI規格です。

## 🚀 5分で導入完了

### 1. CSSファイルを配置
`yy-five-elements-color.css` をあなたのサイトの公開フォルダにアップロード

### 2. HTMLで読み込み
```html
<link rel="stylesheet" href="yy-five-elements-color.css">
```

### 3. 干支に色をつける
```html
<span class="stem-hei">丙</span><span class="branch-uma">午</span>
```

**これだけで完了！** 十干・十二支が五行の色で自動表示されます。

## 🎨 基本的な使い方

### 十干（天干）
```html
<span class="stem-kyou">甲</span>  <!-- 木の陽 = 濃緑 -->
<span class="stem-otsu">乙</span>  <!-- 木の陰 = 薄緑 -->
<span class="stem-hei">丙</span>   <!-- 火の陽 = 濃赤 -->
<span class="stem-tei">丁</span>   <!-- 火の陰 = 薄赤 -->
<span class="stem-bo">戊</span>    <!-- 土の陽 = 濃茶 -->
<span class="stem-ki">己</span>    <!-- 土の陰 = 薄茶 -->
<span class="stem-kou">庚</span>   <!-- 金の陽 = 濃金 -->
<span class="stem-shin">辛</span>  <!-- 金の陰 = 薄金 -->
<span class="stem-jin">壬</span>   <!-- 水の陽 = 濃青 -->
<span class="stem-kai">癸</span>   <!-- 水の陰 = 薄青 -->
```

### 十二支（地支）
```html
<span class="branch-ne">子</span>      <!-- 水 -->
<span class="branch-ushi">丑</span>    <!-- 土 -->
<span class="branch-tora">寅</span>    <!-- 木 -->
<span class="branch-u">卯</span>       <!-- 木 -->
<span class="branch-tatsu">辰</span>   <!-- 土 -->
<span class="branch-mi">巳</span>      <!-- 火 -->
<span class="branch-uma">午</span>     <!-- 火 -->
<span class="branch-hitsuji">未</span> <!-- 土 -->
<span class="branch-saru">申</span>    <!-- 金 -->
<span class="branch-tori">酉</span>    <!-- 金 -->
<span class="branch-inu">戌</span>     <!-- 土 -->
<span class="branch-i">亥</span>       <!-- 水 -->
```

## 🌟 実例：年運遷移の視覚化

```html
<h4>■ 2023｜<span class="stem-kai">癸</span><span class="branch-u">卯</span>（みずのとう）── 水と木の「芽吹き」</h4>
<h4>■ 2024｜<span class="stem-kyou">甲</span><span class="branch-tatsu">辰</span>（きのえたつ）── 木と土の「成長基盤」</h4>
<h4>■ 2025｜<span class="stem-otsu">乙</span><span class="branch-mi">巳</span>（きのとみ）── 木と火が交わり、"燃え始める"</h4>
<h4>■ 2026｜<span class="stem-hei">丙</span><span class="branch-uma">午</span>（ひのえうま）── 火と火の「最強発火」</h4>
```

**結果**: 水（薄青）→ 木（濃緑）→ 木（薄緑）→ 火（濃赤）の色レーンで年運の流れが一目瞭然！

## 📁 パッケージ内容

- **`yy-five-elements-color.css`** - 本体CSSファイル
- **`SPECIFICATION.md`** - 詳細仕様・配色理念・実例解説
- **`EXAMPLES.html`** - 実装サンプル集（ブラウザで確認可能）
- **`docs/`** - 補助資料
  - `60ganshi-table.html` - 60干支フルカラー対応表
  - `color-reference.html` - 全10色の色見本
  - `tokens-map.md` - クラス名完全対応表

## ✨ 特徴

### 占い師にとって
- **脳内変換不要**: 色を見るだけで五行・陰陽が瞬間判別
- **読みやすさ向上**: 長文レポートでも五行の流れが見える
- **学習効率UP**: 命式・年運表が視覚的に理解しやすい

### 技術者にとって
- **超軽量**: 121行のシンプルCSS
- **依存関係なし**: 単体で動作
- **レスポンシブ対応**: あらゆる環境で適用可能

### AIにとって
- **構造化データ**: 五行情報が視覚レイヤーで明確化
- **AEO対応**: AI検索での理解度向上
- **標準化**: 人間とAIで同じ色規格を共有

## 🎯 配色コンセプト

| 五行 | 色相 | 陽（濃い） | 陰（薄い） |
|------|------|-----------|-----------|
| 木 | Green | 森の緑 | 新芽の緑 |
| 火 | Red | 太陽の赤 | 灯火の赤 |
| 土 | Brown | 大地の茶 | 表土の茶 |
| 金 | Gold | 黄金 | 淡い金 |
| 水 | Blue | 深海の青 | 水面の青 |

**統一ルール**: 五行＝色相、陰陽＝明度

## 📞 サポート・カスタマイズ

### 技術的な実装をお手伝いします
占術の理解があるWEB制作者との連携をご希望の場合：

**🏗️ AI魔晄炉・リノベ屋**  
https://rotary.ai-makouro.com/renovation/rinobeya.index.html

※占術の本質を理解したうえでのWEB制作・システム構築が可能です

### ライセンス
- **無料利用・改変・再配布可能**
- **商用利用制限なし**
- 引用時の原典表記推奨: `陰陽五行カラーCSS v1.3（by AI魔晄炉）`

## 📚 詳細情報

より詳しい配色理念・実装例・注意事項については、`SPECIFICATION.md` をご覧ください。

---

**Original concept & palette developed at AI魔晄炉（ai-makouro.com）**  
陰陽五行を統一色規格として整理した世界初のUIパッチ